<?php
session_start();

// İstifadəçi adı və parol
define('USERNAME', 'admin');
define('PASSWORD', '1234');

function updateEnv($key, $value) {
    $envPath = __DIR__ . '/.env';
    $env = file_exists($envPath) ? file_get_contents($envPath) : '';

    if (str_contains($env, "$key=")) {
        $env = preg_replace("/^$key=.*$/m", "$key=$value", $env);
    } else {
        $env .= "\n$key=$value";
    }

    file_put_contents($envPath, trim($env));
}

function getEnvValue($key) {
    $envPath = __DIR__ . '/.env';
    if (!file_exists($envPath)) return null;

    $lines = file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (str_starts_with(trim($line), '#')) continue;
        list($k, $v) = explode('=', $line, 2);
        if (trim($k) == $key) return trim($v);
    }
    return null;
}

function getTelegramInfo($botToken, $chatId) {
    $botName = "Naməlum";
    $chatTitle = "Naməlum";

    if ($botToken) {
        $botInfo = @file_get_contents("https://api.telegram.org/bot{$botToken}/getMe");
        if ($botInfo) {
            $botData = json_decode($botInfo, true);
            $botName = $botData['result']['username'] ?? 'Naməlum';
        }
    }

    if ($botToken && $chatId) {
        $chatInfo = @file_get_contents("https://api.telegram.org/bot{$botToken}/getChat?chat_id={$chatId}");
        if ($chatInfo) {
            $chatData = json_decode($chatInfo, true);
            $chatTitle = $chatData['result']['title'] ?? ($chatData['result']['username'] ?? 'Naməlum');
        }
    }

    return [$botName, $chatTitle];
}

$success = false;
$botToken = getEnvValue('BOT_TOKEN');
$chatId = getEnvValue('CHAT_ID');
list($botName, $chatName) = getTelegramInfo($botToken, $chatId);

// Giriş yoxlaması
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
        if ($_POST['username'] === USERNAME && $_POST['password'] === PASSWORD) {
            $_SESSION['logged_in'] = true;
            header("Location: " . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $login_error = "İstifadəçi adı və ya şifrə yanlışdır!";
        }
    }

    // Giriş formu
    ?>
    <!DOCTYPE html>
    <html lang="az">
    <head>
        <meta charset="UTF-8">
        <title>Giriş</title>
        <script src="https://cdn.tailwindcss.com"></script>
    </head>
    <body class="bg-gray-100 flex items-center justify-center min-h-screen">
        <form method="POST" class="bg-white p-8 rounded-2xl shadow-lg w-full max-w-sm">
            <h2 class="text-2xl font-bold mb-6 text-center text-blue-600">Admin Panelə Giriş</h2>
            <?php if (isset($login_error)): ?>
                <div class="bg-red-100 text-red-700 p-3 rounded mb-4 text-center">
                    <?= $login_error ?>
                </div>
            <?php endif; ?>
            <label class="block mb-2 font-semibold text-gray-700">İstifadəçi adı</label>
            <input type="text" name="username" required
                   class="w-full px-4 py-2 border rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-400"
                   placeholder="Məs: admin" />

            <label class="block mt-4 mb-2 font-semibold text-gray-700">Şifrə</label>
            <input type="password" name="password" required
                   class="w-full px-4 py-2 border rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-400"
                   placeholder="********" />

            <button type="submit" name="login"
                    class="mt-6 w-full bg-blue-600 text-white font-semibold py-2 px-4 rounded-xl hover:bg-blue-700 transition">
                Giriş et
            </button>
        </form>
    </body>
    </html>
    <?php
    exit;
}

// Əsas panel
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bot_token'], $_POST['chat_id'])) {
    updateEnv('BOT_TOKEN', $_POST['bot_token']);
    updateEnv('CHAT_ID', $_POST['chat_id']);
    $botToken = $_POST['bot_token'];
    $chatId = $_POST['chat_id'];
    list($botName, $chatName) = getTelegramInfo($botToken, $chatId);
    $success = true;
}
?>

<!DOCTYPE html>
<html lang="az">
<head>
  <meta charset="UTF-8">
  <title>Telegram Ayarları</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
  <div class="bg-white p-8 rounded-2xl shadow-lg w-full max-w-md">
    <h2 class="text-2xl font-bold mb-6 text-center text-blue-600">Telegram Parametrləri</h2>
    <?php if ($success): ?>
      <div class="bg-green-100 text-green-700 p-3 rounded mb-4 text-center">
        Məlumat uğurla yadda saxlanıldı!
      </div>
    <?php endif; ?>
    <form method="POST">
      <label class="block mb-2 font-semibold text-gray-700">Bot Token</label>
      <input type="text" name="bot_token" required value="<?= htmlspecialchars($botToken) ?>"
             class="w-full px-4 py-2 border rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-400"
             placeholder="Nümunə: 123456:ABCdef..." />

      <label class="block mt-4 mb-2 font-semibold text-gray-700">Chat ID</label>
      <input type="text" name="chat_id" required value="<?= htmlspecialchars($chatId) ?>"
             class="w-full px-4 py-2 border rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-400"
             placeholder="Nümunə: -1001234567890" />

      <button type="submit"
              class="mt-6 w-full bg-blue-600 text-white font-semibold py-2 px-4 rounded-xl hover:bg-blue-700 transition">
        Yadda saxla
      </button>
    </form>

    <?php if ($botToken && $chatId): ?>
    <div class="mt-6 bg-gray-50 p-4 rounded-xl text-sm text-gray-800">
      <p><strong>Bot istifadəçi adı:</strong> <?= htmlspecialchars($botName) ?></p>
      <p><strong>Qrup / Chat adı:</strong> <?= htmlspecialchars($chatName) ?></p>
    </div>
    <?php endif; ?>
  </div>
</body>
</html>
