<?php
function checkIPLimit($ip) {
    $ipFile = __DIR__ . '/ip_logs.json';
    
    // Create file if it doesn't exist
    if (!file_exists($ipFile)) {
        file_put_contents($ipFile, json_encode([]));
    }
    
    // Read existing IP data
    $ipData = json_decode(file_get_contents($ipFile), true);
    
    // Clean old entries (older than 24 hours)
    $now = time();
    foreach ($ipData as $address => $data) {
        if ($now - $data['last_time'] > 86400) { // 24 hours
            unset($ipData[$address]);
        }
    }
    
    // Check current IP
    if (!isset($ipData[$ip])) {
        $ipData[$ip] = [
            'count' => 1,
            'last_time' => $now
        ];
    } else {
        if ($ipData[$ip]['count'] >= 7) {
            return false; 
        }
        $ipData[$ip]['count']++;
        $ipData[$ip]['last_time'] = $now;
    }
    
    // Save updated data
    file_put_contents($ipFile, json_encode($ipData));
    return true;
}